/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.UUID;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MammothEntity
extends Animal
implements NeutralMob {
    private static final UniformInt ANGER_TIME_RANGE;
    public static final EntityDataAccessor<Integer> ATTACK_TICKS;
    private int angerTime;
    private UUID targetUuid;
    private int attackTicksLeft;

    public MammothEntity(EntityType<? extends MammothEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMammothAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 0.5);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)EntityInit.MAMMOTH.m_20615_((Level)world);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_41864_ || stack.m_41720_() == Items.f_41865_ || stack.m_41720_() == Items.f_42210_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new MammothRevengeGoal());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((MammothEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_9236_(), nbt);
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public void m_7870_(int ticks) {
        this.angerTime = ticks;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public UUID m_6120_() {
        return this.targetUuid;
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundInit.MAMMOTH_BABY_IDLE_EVENT : SoundInit.MAMMOTH_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.MAMMOTH_HIT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.MAMMOTH_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)this.attackTicksLeft);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
            this.m_20088_().m_135381_(ATTACK_TICKS, (Object)this.attackTicksLeft);
        }
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        if (entityData == null) {
            entityData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    static {
        ATTACK_TICKS = SynchedEntityData.m_135353_(MammothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)MammothEntity.this, 1.15, true);
        }

        public void m_6739_(LivingEntity target, double squaredDistance) {
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)target);
            }
        }

        public double m_6639_(LivingEntity entity) {
            return 4.5f + entity.m_20205_();
        }
    }

    private class MammothRevengeGoal
    extends HurtByTargetGoal {
        public MammothRevengeGoal() {
            super((PathfinderMob)MammothEntity.this, new Class[0]);
        }

        public void m_8056_() {
            super.m_8056_();
            if (MammothEntity.this.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        public void m_5766_(Mob mob, LivingEntity target) {
            if (mob instanceof MammothEntity && !mob.m_6162_()) {
                super.m_5766_(mob, target);
            }
        }
    }
}

